// @name "Volume (04.09.2013)"
// @author "NADIR1"

volume_bar = function (vx, vy, vw, vh) {
	var v_drag,
	v_drag_hov,
	volpos,
	g_hover_vol = 0;

	this.pos2vol = function (pos) {
		return (50 * Math.log(0.99 * ((vy + vh + (vw / 2) - pos) / vh < 0 ? 0 : (vy + vh + (vw / 2) - pos) / vh) + 0.01) / Math.LN10);
	}

	this.vol2pos = function (v, w2) {
		return (w2 - Math.round(((Math.pow(10, v / 50) - 0.01) / 0.99) * w2));
	}

	this.vol2percentage = function (v) {
		var p = ((Math.pow(10, v / 50) - 0.01) / 0.99);
		return (p);
	}

	this.draw = function (gr) {

		var volume = fb.Volume;

		volpos = this.vol2pos(volume, vh);
		percentage = g_volume.vol2percentage(volume);
		vol_txt = Math.ceil(percentage * 100);

		if (g_hover_vol) {

			gr.FillSolidRect(vx - 22, vy - 52, vw + 44, vh + 84, setAlpha(g_textcolor, 50));

			gr.FillSolidRect(vx - 20, vy - 50, vw + 40, vh + 80, g_backcolor);
			gr.FillSolidRect(vx, vy, vw, vh + vw, g_select_bg_col);
			gr.FillSolidRect(vx, vy, vw, volpos + vw, blendColors(g_textcolor, g_backcolor, 0.85));
			gr.FillSolidRect(vx, vy + volpos, vw, vw, g_textcolor);

			gr.GdiDrawText(vol_txt, gdi.Font("Segoe UI", 14, 1), g_textcolor, vx - 10, vy - 40, vw + 20, 30, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
		}

		gr.GdiDrawText("" + (g_hover_vol ? "" : " " + vol_txt), gdi.Font("Segoe UI", 12, 0), g_textcolor, vx - 25, vy + vh + 50, vw + 50, 30, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

	}

	this.repaint = function (mode) {
		window.RepaintRect(vx - 25, vy - 52, vw + 50, vh + 124);
	}

	this.checkstate = function (event, x, y, step) {
		switch (event) {
		case "down":
			if (v_drag_hov) {
				v_drag = true;
				on_mouse_move(x, y);
			} else {
				v_drag = false;
			}
			break;
		case "up":
			v_drag = false;
			break;
		case "wheel":
			if (v_drag_hov) {
				if (step > 0)
					fb.VolumeUp();
				else
					fb.VolumeDown();
				this.repaint();
			}
			break;
		case "move":
			var hover = (x > vx - 5 && x < vx - 5 + vw + 10 && y > vy - 10 && y < vy - 10 + vh + 20);
			var hover2 = (x > vx - 25 && x < vx - 25 + vw + 50 && y > vy - 52 && y < vy - 52 + vh + 124);
			var hover3 = (x > vx - 25 && x < vx - 25 + vw + 50 && y > vy + vh + 50 && y < vy + vh + 80);

			if (v_drag) {
				g_hover_vol = true;
			} else {
				var tmp = g_hover_vol;
				if (hover3) {
					g_hover_vol = true;
				} else if (!hover2) {
					g_hover_vol = false;
				}
				if (g_hover_vol != tmp || g_hover_vol) {
					this.repaint();
				}
			}

			var tmp = v_drag_hov;
			if (hover && g_hover_vol) {
				v_drag_hov = true;
			} else {
				v_drag_hov = false;
			}
			if (tmp != v_drag_hov)
				this.repaint();

			if (v_drag) {
				var v = this.pos2vol(y);
				if (v <= -100)
					v = -100;
				if (v >= 0)
					v = 0;
				fb.Volume = v;
			}

			break;
		case "leave":
			g_hover_vol = false;
			this.repaint();
			break;
		}
	}
}
